package org.msh.tb;

import org.jboss.seam.annotations.Name;
import org.msh.tb.entities.UserMessage;
import org.msh.utils.EntityQuery;

@Name("userMessages")
public class UserMessagesQuery extends EntityQuery<UserMessage> {
	private static final long serialVersionUID = -5768778841232894814L;

	public static final int ALL_MESSAGES_ORDERED = 0;
	public static final int UNREAD_MESSAGES = 1;
	
	private Integer userWorkspaceCount;

	private Integer filterOption;
	
	@Override
	public String getEjbql() {
		String s;

		if (filterOption != null) {
			switch (filterOption.intValue()) {
				case UNREAD_MESSAGES:
					s = "from UserMessage um where #{userWorkspace} not member of um.users and um.workspace.id = #{defaultWorkspace.id} ";
					break;
				case ALL_MESSAGES_ORDERED:
					s = "from UserMessage um where um.workspace.id = #{defaultWorkspace.id} ";
					break;
				default:
					s = "from UserMessage um where um.workspace.id = #{defaultWorkspace.id} ";
			}
		} else {
			s = "from UserMessage um where um.workspace.id = #{defaultWorkspace.id} ";
		}

		return s;
	}

	@Override
	public String getOrder() {
		String s = super.getOrder();
		if (s == null)
			 return "um.creationDate desc";
		else return s;
	}


	@Override
	protected String getCountEjbql() {
		String s;

		if (filterOption != null) {
			switch (filterOption.intValue()) {
				case UNREAD_MESSAGES:
					s = "select count(*) from UserMessage um where #{userWorkspace} not member of um.users and um.workspace.id = #{defaultWorkspace.id} ";
					break;
				case ALL_MESSAGES_ORDERED:
					s = "select count(*) from UserMessage um where workspace.id = #{defaultWorkspace.id}";
					break;
				default:
					s = "select count(*) from UserMessage um where workspace.id = #{defaultWorkspace.id}";
			}
		} else {
			s = "select count(*) from UserMessage um where workspace.id = #{defaultWorkspace.id}";
		}

		return s;
	}

	@Override
	public Integer getMaxResults() {
		return 15;
	}

	private void loadUserWorkspaceCount() {
		Long res = (Long) getEntityManager().createQuery("select count(*) from UserWorkspace uw where uw.workspace.id = #{defaultWorkspace.id}")
				.getSingleResult();

		userWorkspaceCount = (res == null ? 0 : res.intValue());
	}

	public Integer getUserWorkspaceCount() {
		if (userWorkspaceCount == null) {
			loadUserWorkspaceCount();
		}
		return userWorkspaceCount;
	}

	public void setUserWorkspaceCount(Integer userWorkspaceCount) {
		this.userWorkspaceCount = userWorkspaceCount;
	}

	public Integer getFilterOption() {
		return filterOption;
	}

	public void setFilterOption(Integer filterOption) {
		this.filterOption = filterOption;
	}
}
